package gov.va.med.mhv.integration.phr.service;

import gov.va.med.mhv.integration.phr.transfer.QueryRequest;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;

public class ExtractStationController {
    private static final String ALL_STATIONS = "0";
    
    private List<String> allStationsExtracts = null;
    
    @Autowired
	protected ServiceLocator<QueryService, QueryRequest> queryServiceLocator;

    public Set<String> process(Set<String> stationNumbers, String icn, String extractType) {
    	
    	
    	String serviceId = this.queryServiceLocator.getServiceId(icn, extractType);
    	
        if(!(stationNumbers==null || stationNumbers.isEmpty())) {
        	if(this.allStationsExtracts.contains(serviceId))
        	{
        		Set<String> results = new HashSet<String>();
                results.add(ALL_STATIONS);
                return results;
        	}
        }
	    return stationNumbers;
    }
    
    public void setAllStationsExtracts(List<String> allStationsExtracts) {
		this.allStationsExtracts = allStationsExtracts;
	}
    
    public void setQueryServiceLocator(
			ServiceLocator<QueryService, QueryRequest> queryServiceLocator) {
		this.queryServiceLocator = queryServiceLocator;
	}

}
